/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validator.AccountValidator.java
 * Desprition : This Validator class is responsible for checking and validating the 
 * Customer Account Information
 * 
 */
package Validators;

import DataClasses.*;
/**
 * @author student
 *
 * This class is being used for validating the account limits that a
 * user has.
 * 
 */
public class AccountValidator {
	private String message;

	/**
	 * This method is being used for getting the error message
	 * to be displayed.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used for setting the error message that
	 * is to be displayed.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used for validating the account and 
	 * and the stock details of the given user.
	 * @param userdata The user whose details are to be validated.
	 * @param stockdata The stock which is to be bought.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(User_Data userdata, Stock_Data stockdata) {
		boolean bool = false;
		double amount, stockValue, account;
		int qty;

		account = userdata.getAccount();
		stockValue = stockdata.getPrice();
		qty = Integer.parseInt(stockdata.getQuantity());

		amount = qty * stockValue;
		if (account < amount) {
			setMessage("You have insufficent funds for the transaction.");
			return bool = false;
		} else if (account >= amount)
			return bool = true;
		return bool;
	}

	/**
	 * This method is being used for validating the given user's account 
	 * account details.
	 * @param userdata The user whose account is to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(User_Data userdata) {
		boolean bool = true;
		double prebillamount, account;

		account = userdata.getAccount();
		prebillamount = Double.parseDouble(userdata.getPreBillingAmount());

		if (account > 100000.0) {
			setMessage("The account value must not exceed $100,000.");
			bool = false;
			return bool;
		}
		if (prebillamount > 10000.0) {
			setMessage("The prebilling value must not exceed $10,000.");
			bool = false;
			return bool;
		}

		return bool;
	}

}
